<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

$widget = $args['this'];


$widget->start_controls_section(
    'progress_temp7_text',
    [
        'label'      => __( 'Heading Text', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-7',
        ],
    ]
);
$widget->add_control(
    'progress_temp7_show_hide',
    [
        'label'         => __( 'Show/Hide Text', 'codesigner' ),
        'type'          => Controls_Manager::SWITCHER,
        'label_on'      => __( 'Show', 'codesigner' ),
        'label_off'     => __( 'Hide', 'codesigner' ),
        'return_value'  => 'yes',
        'default'       => 'yes',
    ]
);
$widget->add_control(
    'template7_billing_address_txt',
    [
        'label'         => __( 'Billing Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Billing Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp7_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'template7_ship_to_txt',
    [
        'label'         => __( 'Ship To Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Ship to a different address?', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp7_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'template7_shipping_address_txt',
    [
        'label'         => __( 'Shipping Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Shipping Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp7_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'temp-7-order-notes',
    [
        'label'         => __( 'Order Notes', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order Notes(optional)', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp3_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'template7_order_address_txt',
    [
        'label'         => __( 'Order Info Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp7_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'template7_payment_method_txt',
    [
        'label'         => __( 'Payment Info Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Payment Methods', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp7_show_hide' => 'yes'
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'temp7_order_btn_text',
    [
        'label'      => __( 'Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-7',
        ],
    ]
);
$widget->add_control(
    'order_btn_txt_temp7',
    [
        'label'         => __( 'Order Button', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Proceed To Checkout', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->end_controls_section();
/**
 * template-7 background and border colors
 */
$widget->start_controls_section(
    'template7_coupon_form_style',
    [
        'label'      => __( 'Coupon Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-7',
        ],
    ]
);
$widget->start_controls_tabs(
    'template7_coupon_form_style_tabs'
);
$widget->start_controls_tab(
    'template7_coupon_form_message_tab',
    [
        'label' => esc_html__( 'Message', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template7_coupon_form_message_typography',
        'selector'  => ' .codesigner {{WRAPPER}} .woocommerce-error',
    ]
);

$widget->add_control(
    'template7_coupon_form_message_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            ' .codesigner {{WRAPPER}} .woocommerce-error' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'template7_coupon_form_input_tab',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template7_coupon_form_input_typography',
        'selector'  => '{{WRAPPER}} #cd-coupon-main .input-text',
    ]
);

$widget->add_control(
    'template7_coupon_form_input_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-main .input-text' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-coupon-main .input-text:focus' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'template7_coupon_form_input_placeholder_color',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-main .input-text::placeholder' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'template7_coupon_form_input_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-main .input-text' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'      => 'template7_coupon_form_input_border',
        'selector'  => '{{WRAPPER}} #cd-coupon-main .input-text, 
                        {{WRAPPER}} #cd-coupon-main .input-text:focus',
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name'      => 'template7_coupon_form_input_box_shadow',
        'selector'  => '{{WRAPPER}} #cd-coupon-main .input-text',
    ]
);

$widget->add_control(
    'template7_coupon_form_input_padding',
    [
        'label'         => esc_html__( 'Padding', 'codesigner-pro' ),
        'type'          => Controls_Manager::DIMENSIONS,
        'size_units'    => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'     => [
            '{{WRAPPER}} #cd-coupon-main .input-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_responsive_control(
    'template7_coupon_form_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '.woocommerce form.checkout_coupon [name=coupon_code]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'template7_coupon_from_apply_style',
    [
        'label'      => __( 'Coupon Form Submit', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-7',
        ],
    ]
);

$widget->start_controls_tabs(
    'template7_coupon_form_apply_style_tabs'
);

$widget->start_controls_tab(
    'template7_coupon_form_normal_tab',
    [
        'label' => esc_html__( 'Normal', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template7_coupon_form_normal_apply_typography',
        'selector'  => '.codesigner .checkout_coupon button[type="submit"]',
    ]
);

$widget->add_control(
    'template7_coupon_form_normal_apply_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'template7_coupon_form_normal_apply_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'      => 'template7_coupon_form_normal_apply_border',
        'selector'  => '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]',
    ]
);

$widget->add_control(
    'template7_coupon_form_normal_apply_border_radius',
    [
        'label'         => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type'          => Controls_Manager::DIMENSIONS,
        'size_units'    => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'     => [
            '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name'      => 'template7_coupon_form_normal_apply_box_shadow',
        'selector'  => '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]',
    ]
);

$widget->add_control(
    'template7_coupon_form_normal_apply_padding',
    [
        'label'         => esc_html__( 'Padding', 'codesigner-pro' ),
        'type'          => Controls_Manager::DIMENSIONS,
        'size_units'    => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'     => [
            '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'template7_coupon_form_hover_tab',
    [
        'label' => esc_html__( 'Hover', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template7_coupon_form_hover_apply_typography',
        'selector'  => '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]:hover',
    ]
);

$widget->add_control(
    'template7_coupon_form_hover_apply_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]:hover' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'template7_coupon_form_hover_apply_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]:hover' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'      => 'template7_coupon_form_hover_apply_border',
        'selector'  => '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]:hover',
    ]
);

$widget->add_control(
    'template7_coupon_form_hover_apply_border_radius',
    [
        'label'         => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type'          => Controls_Manager::DIMENSIONS,
        'size_units'    => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'     => [
            '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name'      => 'template7_coupon_form_hover_apply_box_shadow',
        'selector'  => '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]:hover',
    ]
);

$widget->add_control(
    'template7_coupon_form_hover_apply_padding',
    [
        'label'         => esc_html__( 'Padding', 'codesigner-pro' ),
        'type'          => Controls_Manager::DIMENSIONS,
        'size_units'    => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'     => [
            '.codesigner {{WRAPPER}} .checkout_coupon p button[type="submit"]:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'template7_billing_section',
    [
        'label'      => __( 'Billing & Shipping Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-7',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template7_billing_heading_typography',
        'selector'  => '{{WRAPPER}} #cd-checkout-template-7 .cd-checkout-tag',
    ]
);
$widget->add_control(
    'template7_billing_heading_color',
    [
        'label'     => esc_html__( 'Billing Text Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .cd-checkout-tag' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'template7_billing_shipping_bg',
    [
        'label' 	=> esc_html__( 'Parent Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .cd-checkout-address-container' => 'background: {{VALUE}} ',
            '{{WRAPPER}} #cd-checkout-template-7 .cd-checkout-address-container' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template7_billing_shipping_bg_color',
    [
        'label' 	=> esc_html__( 'Billing & Shipping Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .cd-checkout-address' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'template7_billing_shipping_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-checkout-template-7 .cd-checkout-address'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'template7_billing_shipping_section_shadow',
        'selector' 	=> '{{WRAPPER}} #cd-checkout-template-7 .cd-checkout-address',
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'template7_billing_form_style',
    [
        'label'      => __( 'Billing & Shipping Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-7',
        ],
    ]
);
$widget->start_controls_tabs(
    'template7_billing_form_design'
);
$widget->start_controls_tab(
    'template7_form_message_label',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'       => 'template7_form_message_typography',
        'selector'   => '{{WRAPPER}} #cd-checkout-template-7 #cd-billing-section .form-row label,
                         {{WRAPPER}} #cd-checkout-template-7 #cd-shipping-section .form-row label'     
    ]
);
$widget->add_control(
    'template7_form_text_color',
    [
        'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 #cd-billing-section h3'         => 'color: {{VALUE}};' ,
            '{{WRAPPER}} #cd-checkout-template-7 #cd-shipping-section h3'        => 'color: {{VALUE}};' ,
            '{{WRAPPER}} #cd-checkout-template-7 #cd-payment-method-section h3'  => 'color: {{VALUE}};'
        ],
    ]
);
$widget->add_control(
    'template7_form_label_color',
    [
        'label'     => esc_html__( 'Label Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            ' {{WRAPPER}} #cd-checkout-template-7 #cd-billing-section .form-row label'  => 'color: {{VALUE}};' ,
            '{{WRAPPER}} #cd-checkout-template-7 #cd-shipping-section .form-row label'  => 'color: {{VALUE}};'
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'template7_form_message_input',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template7_form_input_typography',
        'selector'  => '{{WRAPPER}} .woocommerce-input-wrapper input,
                        {{WRAPPER}} .woocommerce-input-wrapper select,
                        {{WRAPPER}} .woocommerce-input-wrapper select .select2-selection'

    ]
);
$widget->add_control(
    'template7_form_input_color',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce-input-wrapper input '            => 'color: {{VALUE}}',
            '{{WRAPPER}} .woocommerce-input-wrapper select '           => 'color: {{VALUE}}',
            '{{WRAPPER}} .woocommerce-input-wrapper input input:focus' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'template7_form_input_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 #cd-billing-section .form-row input'   => 'background: {{VALUE}}',
            '{{WRAPPER}} #cd-checkout-template-7 #cd-billing-section .form-row select'  => 'background: {{VALUE}}',
            '{{WRAPPER}} #cd-checkout-template-7 #cd-shipping-section .form-row input'  => 'background: {{VALUE}}',
            '{{WRAPPER}} #cd-checkout-template-7 #cd-shipping-section .form-row select' => 'background: {{VALUE}}',
            '{{WRAPPER}} .woocommerce-js .select2-container--default .select2-selection--single .select2-selection__rendered' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'template7_form_input_box_shadow',
        'selector' 	=> '{{WRAPPER}} #cd-checkout-template-7 #cd-billing-section .form-row input, 
                        {{WRAPPER}} #cd-checkout-template-7 #cd-billing-section .form-row select,
                        {{WRAPPER}} #cd-checkout-template-7 #cd-shipping-section .form-row input,
                        {{WRAPPER}} #cd-checkout-template-7 #cd-shipping-section .form-row select' 
    ]
);
$widget->add_responsive_control(
    'template7_form_input_padding',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Padding', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-checkout-template-7 #cd-billing-section .woocommerce-input-wrapper input '  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

            '{{WRAPPER}} #cd-checkout-template-7 #cd-shipping-section .woocommerce-input-wrapper input '  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

            '{{WRAPPER} #cd-checkout-template-7 #cd-billing-section .woocommerce-input-wrapper select ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

            '{{WRAPPER} #cd-checkout-template-7 #cd-shipping-section .woocommerce-input-wrapper select ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_responsive_control(
    'template7_form_input_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Input Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-checkout-template-7 #cd-billing-section .woocommerce-input-wrapper input '  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

            '{{WRAPPER}} #cd-checkout-template-7 #cd-shipping-section .woocommerce-input-wrapper input '  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

            '{{WRAPPER} #cd-checkout-template-7 #cd-billing-section .woocommerce-input-wrapper select ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

            '{{WRAPPER} #cd-checkout-template-7 #cd-shipping-section .woocommerce-input-wrapper select ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section (
    'template7_order_notes_label',
    [
        'label'      => __( 'Order Notes', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-7',
        ],
    ]
);
$widget->start_controls_tabs(
    'template7_order_notes_form_design'
);
$widget->start_controls_tab(
    'template7_order_notes_label_tab',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'       => 'template7_order_notes_typography',
        'selector'   => '{{WRAPPER}} #cd-checkout-template-7 .order-notes #order_comments_field label '     
    ]
);
$widget->add_control(
    'template7_order_notes_label_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .order-notes .form-row label' => 'color: {{VALUE}};'
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'template7_order_notes_input_tab',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template7_order_notes_input_typography',
        'selector'  => '{{WRAPPER}} #cd-checkout-template-7 .order-notes .form-row textarea  '

    ]
);
$widget->add_control(
    'template7_order_notes_input_color_placeholder',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .order-notes .form-row::placeholder'   => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'template7_order_notes_input_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .order-notes .form-row textarea' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'template7_order_notes_input_box_shadow',
        'selector' 	=> ' {{WRAPPER}} #cd-checkout-template-7 .order-notes .form-row textarea ' 
    ]
);
$widget->add_responsive_control(
    'template7_order_notes_input_padding',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Padding', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-checkout-template-7 .order-notes .form-row textarea '   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();
$widget->start_controls_section(
    'cd_checkout_template1_ship_to_diffe7ent',
    [
        'label'      => __( 'Ship to different input', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-7',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template7_ship_to_different_typography',
        'selector'  => '{{WRAPPER}} #cd-checkout-template-7 .different-address-shipping label',
    ]
);
$widget->add_control(
    'template7_ship_to_different_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .different-address-shipping label' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();
$widget->start_controls_section(
    'cd_checkout_template_7_order_contai7er',
    [
        'label'      => __( 'Order Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-7',
        ],
    ]
);
$widget->add_control(
    'template7_order_section_heading',
    [
        'label' 	=> esc_html__( 'Order Heading Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-order-container #cd-checkout-order-id .cd-checkout-order-title h3' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template7_order_heading_typography',
        'selector'  => '{{WRAPPER}} #cd-checkout-order-id .cd-checkout-order-title h3',
    ]
);
$widget->add_control(
    'template7_order_parent_bg',
    [
        'label' 	=> esc_html__( 'Parent Section Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .cd-checkout-order-container' => 'background: {{VALUE}} ',
        ],
    ]
);

$widget->add_control(
    'template7_order_bg',
    [
        'label' 	=> esc_html__( 'Order Details Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .cd-checkout-order' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template7_order_border_radius',
    [
        'label' 	=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::DIMENSIONS,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .cd-checkout-order' => 'border-radius:  {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'template7_order_section_parent_box_shadow',
        'selector' 	=> '{{WRAPPER}} #cd-checkout-template-7 .cd-checkout-order',
    ]
);
$widget->start_controls_tabs(
    'template7_product_text_control'
);
$widget->start_controls_tab(
    'template7_order_section_product_tab',
    [
        'label' => esc_html__( 'Product', 'codesigner-pro' ),
    ]
);
$widget->add_responsive_control(
    'template7_product_image_control',
    [
        'type'   => Controls_Manager::SLIDER,
        'label'  => esc_html__( 'Image Sizing', 'codesigner-pro' ),
        'range'  => [
            'px' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'devices'         => [ 'desktop', 'tablet', 'mobile' ],
        'desktop_default' => [
            'size' => 64,
            'unit' => 'px',
        ],
        'tablet_default' => [
            'size' => 48,
            'unit' => 'px',
        ],
        'mobile_default' => [
            'size' => 32,
            'unit' => 'px',
        ],
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .codesigner-cart-item-thumbnail img' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);
$widget->add_control(
    'template7_order_title_color',
    [
        'label' 	=> esc_html__( 'Product Section Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .codesigner-single-cart-item'  => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template7_order_element_color',
    [
        'label'     => esc_html__( 'Product Section Element Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .codesigner-temp7-cart-item-wrap p'  => 'color: {{VALUE}} ',
            '{{WRAPPER}} #cd-checkout-template-7 .numberstyle-qty input[type=number]' => 'color: {{VALUE}} ',
            '{{WRAPPER}} #cd-checkout-template-7 .codesinger-cart-item-price bdi'     => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_template7_order_typography',
        'selector'  => '{{WRAPPER}} #cd-checkout-template-7 .codesigner-temp7-cart-item-wrap p,
                        {{WRAPPER}} #cd-checkout-template-7 .numberstyle-qty input[type=number],
                        {{WRAPPER}} #cd-checkout-template-7 .codesinger-cart-item-price bdi',
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'template7_order_section_text_tab',
    [
        'label' => esc_html__( 'Text', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_order_footer_typography',
        'selector'  => '{{WRAPPER}} #cd-checkout-tfoot th,
                        {{WRAPPER}} #cd-checkout-tfoot td',                  
    ]
);
$widget->add_control(
    'template7_order_text_color',
    [
        'label' 	=> esc_html__( 'Footer Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 #cd-checkout-tfoot th'  => 'color: {{VALUE}} ',
            '{{WRAPPER}} #cd-checkout-template-7 #cd-checkout-tfoot td'  => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template7_order_bgcolor',
    [
        'label'     => esc_html__( 'Footer Background Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 table.woocommerce-checkout-review-order-table'  => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'template7_payment_section',
    [
        'label'      => __( 'Payment Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-7',
        ],
    ]
);
$widget->add_control(
    'template7_payment_method_bg',
    [
        'label' 	=> esc_html__( 'Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 #payment > ul.wc_payment_methods.payment_methods.methods' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template7_order_payment_typography',
        'selector'  => '{{WRAPPER}} #add_payment_method #payment ul.payment_methods li,
                        {{WRAPPER}} .woocommerce-cart #payment ul.payment_methods li,
                        {{WRAPPER}} .woocommerce-checkout #payment ul.payment_methods li',                  
    ]
);
$widget->add_control(
    'template7_payment_section_colors',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 .wc_payment_method label' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template7_payment_section_box_bgcolor',
    [
        'label' 	=> esc_html__( 'Box Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 div#cd-payment-method #payment .payment_methods > li:not(.woocommerce-notice)' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template7_payment_section_box_border_color',
    [
        'label' 	=> esc_html__( 'Box Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 #payment div.payment_box'         => 'border-color: {{VALUE}} ',
            '{{WRAPPER}} #cd-checkout-template-7 #payment div.payment_box::before' => 'border-bottom-color: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_template_7_submit_butto7',
    [
        'label'      => __( 'Place Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-7',
        ],
    ]
);
$widget->start_controls_tabs(
    'cd_checkout_order_place'
);

$widget->start_controls_tab(
    'cd_checkout_order_place_normal_tab',
    [
        'label' => esc_html__( 'Normal', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_order_place_typography',
        'selector'  => '{{WRAPPER}} #cd-checkout-template-7 button#place_order',
    ]
);
$widget->add_control(
    'cd_checkout_order_place_bg',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 button#place_order' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_order_place_text_color',
    [
        'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 button#place_order' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'      => 'cd_checkout_order_place_border',
        'selector'  => '#cd-checkout-template-7 button#place_order',
    ]
);
$widget->add_responsive_control(
    'cd_checkout_order_place_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '#cd-checkout-template-7 button#place_order' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name'      => 'cd_checkout_order_place_box_shadow',
        'selector'  => '{{WRAPPER}} #cd-checkout-template-7 button#place_order',
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_order_place_hover_tab',
    [
        'label' => esc_html__( 'Hover', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_order_place_hvr_typography',
        'selector'  => '{{WRAPPER}} #cd-checkout-template-7 button#place_order:hover',
    ]
);
$widget->add_control(
    'cd_checkout_order_place_hvr_bg',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 button#place_order:hover' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_order_place_hvr_text_color',
    [
        'label'     => esc_html__( 'Text Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-template-7 button#place_order:hover' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name'      => 'cd_checkout_hvr_order_place_border',
        'selector'  => '#cd-checkout-template-7 button#place_order:hover',
    ]
);
$widget->add_responsive_control(
    'cd_checkout_order_place_hvr_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '#cd-checkout-template-7 button#place_order:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name'      => 'cd_checkout_hvr_order_place_box_shadow',
        'selector'  => '{{WRAPPER}} #cd-checkout-template-7 button#place_order:hover',
    ]
);
$widget->end_controls_tab();
$widget->end_controls_section();